
// automatically generated by m4 from headers in proto subdir


#ifndef __ARCH_TS2068_H__
#define __ARCH_TS2068_H__

#include <arch.h>

#include <stddef.h>
#include <rect.h>

// COMMON CONSTANTS

#define INK_BLACK                   0x00
#define INK_BLUE                    0x01
#define INK_RED                     0x02
#define INK_MAGENTA                 0x03
#define INK_GREEN                   0x04
#define INK_CYAN                    0x05
#define INK_YELLOW                  0x06
#define INK_WHITE                   0x07

#define PAPER_BLACK                 0x00
#define PAPER_BLUE                  0x08
#define PAPER_RED                   0x10
#define PAPER_MAGENTA               0x18
#define PAPER_GREEN                 0x20
#define PAPER_CYAN                  0x28
#define PAPER_YELLOW                0x30
#define PAPER_WHITE                 0x38

#define BRIGHT                      0x40
#define FLASH                       0x80

// GLOBAL VARIABLES

extern unsigned char GLOBAL_TS_PORT_FE;
extern unsigned char GLOBAL_ZX_PORT_FE;

// IO MAPPED REGISTERS

#ifdef __CLANG

extern unsigned char IO_FE;

#else

__sfr __at 0xfe IO_FE;

#endif

// misc

extern void zx_border(unsigned char colour);


extern void zx_cls(unsigned char attr);


extern void zx_cls_wc(struct r_Rect8 *r,unsigned char attr);


extern void zx_scroll_up(unsigned char rows,unsigned char attr);


extern void zx_scroll_wc_up(struct r_Rect8 *r,unsigned char rows,unsigned char attr);



// display

// In the following, screen address refers to a pixel address within the display file while
// attribute address refers to the attributes area.
//
// Function names are constructed from the following atoms:
//
// saddr = screen address
// aaddr = attribute address
// 
// px    = pixel x coordinate (0..255)
// py    = pixel y coordinate (0..191)
// pxy   = pixel (x,y) coordinate
//
// cx    = character x coordinate (0..31)
// cy    = character y coordinate (0..23)
// cxy   = character (x,y) coordinate
//
// So for example:
//
// zx_saddr2cy(saddr) will return the character y coordinate corresponding to the given screen address
// zx_saddr2aaddr(saddr) will return the attribute address corresponding to the given screen address
// zx_pxy2aaddr(px,py) will return the attribute address corresponding to the given (x,y) pixel coordinate
//
// Some functions will return with carry flag set if coordinates or addresses move out of
// bounds.  In these cases the special z88dk keywords iferror() and ifnerror() can be used
// to test the carry flag and determine if invalid results are returned.  Check with the
// wiki documentation or the asm source files to see which functions support this.  If
// comments in the asm source file do not mention this, it is not supported.

// Standard Spectrum Display 256x192 pixel 32x24 colour

extern unsigned char zx_aaddr2cx(void *aaddr);


extern unsigned char zx_aaddr2cy(void *aaddr);


extern unsigned char zx_aaddr2px(void *aaddr);


extern unsigned char zx_aaddr2py(void *aaddr);


extern unsigned char *zx_aaddr2saddr(void *aaddr);


extern unsigned char *zx_aaddrcdown(void *aaddr);


extern unsigned char *zx_aaddrcleft(void *aaddr);


extern unsigned char *zx_aaddrcright(void *aaddr);


extern unsigned char *zx_aaddrcup(void *aaddr);


extern unsigned char zx_bitmask2px(unsigned char bitmask);


extern unsigned char *zx_cxy2aaddr(unsigned char x,unsigned char y);


extern unsigned char *zx_cxy2saddr(unsigned char x,unsigned char y);


extern unsigned char *zx_cy2aaddr(unsigned char y);


extern unsigned char *zx_cy2saddr(unsigned char y);


extern unsigned char zx_px2bitmask(unsigned char x);


extern unsigned char *zx_pxy2aaddr(unsigned char x,unsigned char y);


extern unsigned char *zx_pxy2saddr(unsigned char x,unsigned char y);


extern unsigned char *zx_py2aaddr(unsigned char y);


extern unsigned char *zx_py2saddr(unsigned char y);


extern unsigned char *zx_saddr2aaddr(void *saddr);


extern unsigned char zx_saddr2cx(void *saddr);


extern unsigned char zx_saddr2cy(void *saddr);


extern unsigned int zx_saddr2px(void *saddr);


extern unsigned int zx_saddr2py(void *saddr);


extern unsigned char *zx_saddrcdown(void *saddr);


extern unsigned char *zx_saddrcleft(void *saddr);


extern unsigned char *zx_saddrcright(void *saddr);


extern unsigned char *zx_saddrcup(void *saddr);


extern unsigned char *zx_saddrpdown(void *saddr);


extern unsigned char *zx_saddrpleft(void *saddr,unsigned char bitmask);


extern unsigned char *zx_saddrpright(void *saddr,unsigned char bitmask);


extern unsigned char *zx_saddrpup(void *saddr);



// Timex Hi-Colour Display 256x192 pixel 32x192 colour

extern unsigned char tshc_aaddr2cx(void *aaddr);


extern unsigned char tshc_aaddr2cy(void *aaddr);


extern unsigned char tshc_aaddr2px(void *aaddr);


extern unsigned char tshc_aaddr2py(void *aaddr);


extern unsigned char *tshc_aaddr2saddr(void *aaddr);


extern unsigned char *tshc_aaddrcdown(void *aaddr);


extern unsigned char *tshc_aaddrcleft(void *aaddr);


extern unsigned char *tshc_aaddrcright(void *aaddr);


extern unsigned char *tshc_aaddrcup(void *aaddr);


extern unsigned char *tshc_aaddrpdown(void *aaddr);


extern unsigned char *tshc_aaddrpleft(void *aaddr,unsigned char bitmask);


extern unsigned char *tshc_aaddrpright(void *aaddr,unsigned char bitmask);


extern unsigned char *tshc_aaddrpup(void *aaddr);


extern unsigned char tshc_bitmask2px(unsigned char bitmask);


extern unsigned char *tshc_cxy2aaddr(unsigned char x,unsigned char y);


extern unsigned char *tshc_cxy2saddr(unsigned char x,unsigned char y);


extern unsigned char *tshc_cy2aaddr(unsigned char y);


extern unsigned char *tshc_cy2saddr(unsigned char y);


extern unsigned char tshc_px2bitmask(unsigned char x);


extern unsigned char *tshc_pxy2aaddr(unsigned char x,unsigned char y);


extern unsigned char *tshc_pxy2saddr(unsigned char x,unsigned char y);


extern unsigned char *tshc_py2aaddr(unsigned char y);


extern unsigned char *tshc_py2saddr(unsigned char y);


extern unsigned char *tshc_saddr2aaddr(void *saddr);


extern unsigned char tshc_saddr2cx(void *saddr);


extern unsigned char tshc_saddr2cy(void *saddr);


extern unsigned char tshc_saddr2px(void *saddr);


extern unsigned char tshc_saddr2py(void *saddr);


extern unsigned char *tshc_saddrcdown(void *saddr);


extern unsigned char *tshc_saddrcleft(void *saddr);


extern unsigned char *tshc_saddrcright(void *saddr);


extern unsigned char *tshc_saddrcup(void *saddr);


extern unsigned char *tshc_saddrpdown(void *saddr);


extern unsigned char *tshc_saddrpleft(void *saddr,unsigned char bitmask);


extern unsigned char *tshc_saddrpright(void *saddr,unsigned char bitmask);


extern unsigned char *tshc_saddrpup(void *saddr);



// Timex Hi-Res Display, 512x192 monochrome

extern unsigned char tshr_bitmask2px(unsigned char bitmask);


extern unsigned char *tshr_cxy2saddr(unsigned char x,unsigned char y);


extern unsigned char *tshr_cy2saddr(unsigned char y);


extern unsigned char tshr_px2bitmask(unsigned char x);


extern unsigned char *tshr_pxy2saddr(unsigned int x,unsigned char y);


extern unsigned char *tshr_py2saddr(unsigned char y);


extern unsigned char tshr_saddr2cx(void *saddr);


extern unsigned char tshr_saddr2cy(void *saddr);


extern unsigned int tshr_saddr2px(void *saddr);


extern unsigned char tshr_saddr2py(void *saddr);


extern unsigned char *tshr_saddrcdown(void *saddr);


extern unsigned char *tshr_saddrcleft(void *saddr);


extern unsigned char *tshr_saddrcright(void *saddr);


extern unsigned char *tshr_saddrcup(void *saddr);


extern unsigned char *tshr_saddrpdown(void *saddr);


extern unsigned char *tshr_saddrpleft(void *saddr,unsigned char bitmask);


extern unsigned char *tshr_saddrpright(void *saddr,unsigned char bitmask);


extern unsigned char *tshr_saddrpup(void *saddr);



// graphics

extern int zx_pattern_fill(unsigned char x,unsigned char y,void *pattern,unsigned int depth);



#endif
